<?php
defined('ABSPATH') || exit;

/** --- Segurana: dono do pedido ou ?key= --- */
$order_id = absint($_GET['order_id'] ?? (get_query_var('order-received') ?: 0));
$key_in   = isset($_GET['key']) ? sanitize_text_field($_GET['key']) : '';
$order    = $order_id ? wc_get_order($order_id) : null;
if (!$order) wp_die('Pedido invlido.');

$owner_ok = is_user_logged_in() && (get_current_user_id() === (int) $order->get_user_id());
$key_ok   = $key_in && hash_equals($order->get_order_key(), $key_in);
if (!$owner_ok && !$key_ok) wp_die('Voc no tem permisso para ver este comprovante.');

$brand = get_bloginfo('name');

/* ================= Helpers ================= */
$meta_first = function($item, array $keys, $fallback = '') {
  foreach ($keys as $k) { $v = $item->get_meta($k); if ($v !== '' && $v !== null) return $v; }
  return $fallback;
};
$fmt_dt = function($str){
  if (!$str) return '';
  $ts = strtotime($str);
  return $ts ? date_i18n('d/m/Y H:i', $ts) : $str;
};
$to_float = function($v){
  if (is_numeric($v)) return (float)$v;
  $v = (string)$v;
  $v = preg_replace('/[^\d,.\-]/','',$v);
  $v = preg_replace('/\.(?=\d{3}(?:\D|$))/','',$v);
  $v = str_replace(',', '.', $v);
  return (float)$v;
};

/** Passageiros (nome/telefone) */
$get_passengers = function(WC_Order_Item $item, WC_Order $order){
  $out = [];
  $pi = $item->get_meta('_wbtm_passenger_info');
  if (is_array($pi) && $pi) {
    foreach ($pi as $row) {
      $nome = $row['wbtm_full_name']['value'] ?? ($row['wbtm_full_name'] ?? '');
      $fone = $row['wbtm_reg_phone']['value'] ?? ($row['wbtm_reg_phone'] ?? '');
      $nome = trim((string)$nome); $fone = trim((string)$fone);
      $out[] = ['nome' => $nome ?: (trim($order->get_billing_first_name().' '.$order->get_billing_last_name()) ?: 'Passageiro'), 'fone' => $fone];
    }
  }
  if (!$out) $out[] = ['nome'=>trim($order->get_billing_first_name().' '.$order->get_billing_last_name()) ?: 'Passageiro', 'fone'=>''];
  return $out;
};

/** Tickets/assentos por _wbtm_ticket_info (seat_name) com fallback nas metas "Assento" duplicadas */
$get_ticket_rows = function(WC_Order_Item $item){
  $rows = [];
  $ti = $item->get_meta('_wbtm_ticket_info');
  if (is_array($ti) && $ti) {
    foreach ($ti as $r) {
      $qty  = (int)($r['ticket_qty'] ?? 1);
      $seat = $r['seat_name'] ?? '';
      for ($i=0; $i<max(1,$qty); $i++) {
        $rows[] = [
          'seat'   => trim((string)$seat),
          'tarifa' => trim((string)($r['ticket_name'] ?? '')),
          'price'  => (string)($r['ticket_price'] ?? ''),
          'date'   => (string)($r['date'] ?? '')
        ];
      }
    }
  }
  if (!$rows) {
    foreach ($item->get_meta_data() as $m) {
      $d = $m->get_data();
      if (isset($d['key']) && mb_strtolower($d['key']) === 'assento') {
        $rows[] = ['seat'=>trim((string)$d['value']), 'tarifa'=>'', 'price'=>'', 'date'=>''];
      }
    }
  }
  return $rows;
};

/** Servios extras padro a partir de _extra_services */
$get_extra_services = function(WC_Order_Item $item) use ($to_float){
  $out = []; $ex = $item->get_meta('_extra_services'); if (empty($ex)) return $out;
  $push = function($title,$qty,$price) use (&$out,$to_float){
    $title = trim((string)$title); if ($title==='') return;
    $qty   = (int)($qty ?: 1); $price = $to_float($price);
    $out[] = ['title'=>$title,'qty'=>$qty,'price'=>$price,'total'=>$price*$qty];
  };
  if (is_array($ex)) {
    foreach ($ex as $k=>$v) {
      if (is_array($v)) $push($v['name'] ?? ($v['title'] ?? ($v['service'] ?? $k)), $v['qty'] ?? ($v['quantity'] ?? 1), $v['price'] ?? ($v['valor'] ?? ($v['amount'] ?? 0)));
      else $push($v,1,0);
    }
  } else foreach (preg_split('/\s*,\s*/', (string)$ex) as $s) $push($s,1,0);
  return $out;
};

/** Quantidade total de bilhetes (para linha de corte) */
$total_tickets = 0;
foreach ($order->get_items() as $it) {
  $pass = $get_passengers($it, $order); $trs  = $get_ticket_rows($it);
  $qty_meta = (int)$it->get_meta('_wbtm_qty');
  $total_tickets += max(count($pass), count($trs), (int)$it->get_quantity(), $qty_meta, 1);
}
$printed = 0;
?>
<!doctype html>
<html lang="pt-BR">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Comprovantes</title>

<style>
  /* ======= UI: Cards de impresso ======= */
  body{margin:0;font-family:system-ui,Segoe UI,Roboto,Arial}
  .container{max-width:960px;margin:18px auto;padding:0 12px}
  .grid{display:grid;gap:12px}
  @media(min-width:860px){.grid{grid-template-columns:1fr 1fr}}
  .card{background:#fff;border:1px solid #e5e7eb;border-radius:14px;box-shadow:0 6px 18px rgba(0,0,0,.06);overflow:hidden}
  .card .hd{display:flex;justify-content:space-between;align-items:center;padding:12px 14px;border-bottom:1px solid #eef2f7}
  .card .bd{padding:12px 14px;display:grid;gap:10px}
  .row{display:flex;gap:8px;flex-wrap:wrap;align-items:center}
  .btn{padding:10px 12px;border:0;border-radius:10px;font-weight:700;cursor:pointer}
  .btn[disabled]{opacity:.55;cursor:not-allowed}
  .btn-blue{background:#0ea5e9;color:#fff}
  .btn-green{background:#22c55e;color:#053}
  .btn-ghost{background:#fff;border:1px solid #e5e7eb;color:#111}
  .select{padding:10px;border:1px solid #e5e7eb;border-radius:10px;min-width:240px}
  .status{font-size:13px;color:#475569}
  .dot{width:10px;height:10px;border-radius:999px;background:#cbd5e1;display:inline-block;margin-right:6px;vertical-align:middle}
  .ok{background:#22c55e}.warn{background:#f59e0b}.err{background:#ef4444}

  /* ======= Bilhete (preview 80mm) ======= */
  :root { --w: 80mm; }
  .ticket-wrap{
    width:var(--w); margin:16px auto; font-family:Arial,Helvetica,sans-serif;
    font-size:12px; line-height:1.35; color:#0f172a;
  }
  .ticket{
    page-break-inside: avoid;
    background:#fff; border:1px solid #e5e7eb; border-radius:10px; padding:10px; margin:10px 0;
    box-shadow:0 6px 12px rgba(0,0,0,.06);
  }
  .t-head{ text-align:center; margin:4px 0 2px; }
  .t-head h3{ margin:0; font-size:15px; letter-spacing:.2px }
  .badge-small{
    display:inline-block; padding:2px 8px; border-radius:999px; font-size:11px; color:#0369a1;
    background:#e0f2fe; border:1px solid #bae6fd; margin-top:4px;
  }
  .hr{ border:none; border-top:1px dashed #94a3b8; margin:6px 0 }
  .t-meta{ display:grid; gap:2px; margin-top:2px }
  .t-meta div{ display:flex; justify-content:space-between; gap:6px }
  .t-meta strong{ color:#111827 }
  .t-sec{ margin-top:6px }

  .route{
    display:grid; grid-template-columns:1fr 24px 1fr; align-items:center; gap:6px; margin:6px 0 4px;
  }
  .route .dot{ width:7px; height:7px; border-radius:999px; background:#10b981; margin:0 auto }
  .route .line{ width:2px; height:20px; background:#e2e8f0; margin:0 auto }
  .route .col{ font-size:12px; color:#0f172a }
  .route .col b{ display:block; color:#111827 }

  .tbl{ width:100%; border-collapse:collapse; }
  .tbl td{ padding:2px 0; border-bottom:1px dashed #e5e7eb; vertical-align:top; }
  .tbl tr:last-child td{ border-bottom:0 }
  .tbl td:first-child{ width:44%; color:#334155 }
  .tbl td:last-child{ width:56%; color:#111827; text-align:right }

  .cut{ border:none; border-top:1px dashed #cbd5e1; margin:10px 0; position:relative; }
  .cut:after{ content:'?'; position:absolute; right:0; top:-10px; font-size:10px; color:#94a3b8 }

  @page{ size:auto; margin:0 }
  @media print{ body{ margin:0 } .controls{display:none!important} }
</style>
</head>
<body>

<div class="container controls">
  <div class="grid">
    <!-- QZ Tray -->
    <div class="card">
      <div class="hd">
        <strong>QZ Tray</strong>
        <div class="status"><span id="qz-dot" class="dot"></span><span id="qz-status">Aguardando</span></div>
      </div>
      <div class="bd">
        <div class="row">
          <button id="qz-connect" class="btn btn-blue">Conectar</button>
          <button id="qz-refresh" class="btn btn-ghost">Atualizar lista</button>
          <button id="qz-disconnect" class="btn btn-ghost">Desconectar</button>
        </div>
        <div class="row">
          <select id="qz-select" class="select">
            <option value="" data-placeholder="1">Nenhuma impressora</option>
          </select>
          <button id="qz-print-all"  class="btn btn-green" disabled>QZ  Imprimir TUDO</button>
          <button id="qz-print-each" class="btn btn-ghost" disabled>QZ  Bilhete a Bilhete</button>
        </div>
        <div class="status" style="font-size:12px">Dica: se no listar, abra o app QZ no sistema e clique em Atualizar.</div>
      </div>
    </div>

    <!-- RawBT -->
    <div class="card">
      <div class="hd">
        <strong>RawBT (Android)</strong>
        <div class="status"><span id="rb-dot" class="dot"></span><span id="rb-status">Detectando dispositivo</span></div>
      </div>
      <div class="bd">
        <div class="row">
          <button id="rb-print-all"  class="btn btn-green">RawBT  Imprimir TUDO</button>
          <button id="rb-print-each" class="btn btn-ghost">RawBT  Bilhete a Bilhete</button>
          <button id="rb-open" class="btn btn-ghost">Abrir app</button>
        </div>
        <div class="status" style="font-size:12px">Necessita Android + app RawBT instalado e impressora pareada.</div>
      </div>
    </div>
  </div>
</div>

<!-- ======= BILHETES ======= -->
<div class="ticket-wrap" id="ticketWrap">
<?php
foreach ($order->get_items() as $item_id => $item):

  $name  = $item->get_name();

  $bp      = $meta_first($item, ['_wbtm_bp','Embarque']);
  $bp_time = $meta_first($item, ['_wbtm_bp_time']);
  $dp      = $meta_first($item, ['_wbtm_dp','Deixando cair','Destino']);
  $dp_time = $meta_first($item, ['_wbtm_dp_time']);

  $start_point = $meta_first($item, ['_wbtm_start_point']);
  $start_time  = $meta_first($item, ['_wbtm_start_time']);
  $pickup      = $meta_first($item, ['_wbtm_pickup_point']);
  $dropoff     = $meta_first($item, ['_wbtm_drop_off_point']);
  $bus_id      = $meta_first($item, ['_wbtm_bus_id','_bus_id']);

  $passengers = $get_passengers($item, $order);
  $tickets    = $get_ticket_rows($item);
  $extras     = $get_extra_services($item);

  $qty_meta   = (int)$item->get_meta('_wbtm_qty');
  $here       = max(count($passengers), count($tickets), (int)$item->get_quantity(), $qty_meta, 1);

  $line_total = (float)$item->get_total();
  $rateio     = $here > 0 ? ($line_total / $here) : $line_total;

  for ($i=0; $i<$here; $i++):
    $printed++;
    $p  = $passengers[$i] ?? end($passengers);
    $tr = $tickets[$i]    ?? ['seat'=>'','tarifa'=>'','price'=>'','date'=>''];

    $seat   = trim((string)($tr['seat'] ?? ''));
    $tarifa = ($tr['tarifa'] ?? '') ?: $meta_first($item, ['Tipo de assento'],'');
    $unit   = ($tr['price'] ?? '') !== '' ? $to_float($tr['price']) : $rateio;
?>
  <div class="ticket">
    <div class="t-head">
      <h3><?php echo esc_html($brand); ?></h3>
      <div class="badge-small">Ticket <?php echo ($i+1); ?> de <?php echo $here; ?>  Item</div>
    </div>

    <hr class="hr">
    <div class="t-meta">
      <div><strong>N do pedido</strong><span><?php echo esc_html($order->get_order_number()); ?></span></div>
      <div><strong>Data</strong><span><?php echo esc_html(wc_format_datetime($order->get_date_created())); ?></span></div>
 
      <div><strong>Metodo</strong><span><?php echo esc_html($order->get_payment_method_title()); ?></span></div>
    </div>

    <?php if ($bp || $dp): ?>
      <div class="route">
        <div class="col"><b><?php echo esc_html($bp ?: ($start_point ?: 'Origem')); ?></b><?php echo $bp_time ? esc_html(' ' . $fmt_dt($bp_time)) : ''; ?></div>
        <div><div class="dot"></div><div class="line"></div><div class="dot"></div></div>
        <div class="col" style="text-align:right"><b><?php echo esc_html($dp ?: 'Destino'); ?></b><?php echo $dp_time ? esc_html(' ' . $fmt_dt($dp_time)) : ''; ?></div>
      </div>
    <?php endif; ?>

    <div class="t-sec">
      <table class="tbl">
        <tr><td colspan="2"><strong><?php echo esc_html($name); ?></strong></td></tr>

        <tr><td>Passageiro</td><td><?php echo esc_html($p['nome']); ?></td></tr>
        <?php if (!empty($p['fone'])): ?>
          <tr><td>Telefone</td><td><?php echo esc_html($p['fone']); ?></td></tr>
        <?php endif; ?>

        <?php if ($start_point || $start_time): ?>
          <tr><td>Sada</td><td><?php echo esc_html(($start_point ?: '').($start_time ? ' ('.$fmt_dt($start_time).')' : '')); ?></td></tr>
        <?php endif; ?>
        <?php if ($pickup): ?><tr><td>Ponto de Embarque</td><td><?php echo esc_html($pickup); ?></td></tr><?php endif; ?>
        <?php if ($dropoff): ?><tr><td>Ponto de Desembarque</td><td><?php echo esc_html($dropoff); ?></td></tr><?php endif; ?>

        <tr><td>Categoria/Tarifa</td><td><?php echo esc_html($tarifa); ?></td></tr>
        <tr><td>Assento</td><td><?php echo $seat ? esc_html($seat) : 'Sem assento'; ?></td></tr>
        <tr><td>Valor  unit.</td><td><?php echo wc_price($unit); ?></td></tr>

        <?php if (!empty($extras)): ?>
          <tr>
            <td>Servios extras</td>
            <td>
              <?php foreach ($extras as $ex): ?>
                <div>
                  <?php
                    echo esc_html($ex['title']);
                    if (!empty($ex['qty']) && $ex['qty'] != 1) echo '  '.intval($ex['qty']);
                    if (isset($ex['price'])) echo '  '.wc_price((float)$ex['price']);
                  ?>
                </div>
              <?php endforeach; ?>
            </td>
          </tr>
        <?php endif; ?>

        <?php if ($bus_id): ?>
          <tr><td>nibus/Barco ID</td><td><?php echo esc_html($bus_id); ?></td></tr>
        <?php endif; ?>
      </table>
    </div>

    <hr class="hr">
    <div class="t-meta">
      <div><strong>Subtotal do bilhete</strong><span><?php echo wc_price($unit); ?></span></div>
      <div><strong>Total do pedido</strong><span><?php echo wp_kses_post($order->get_formatted_order_total()); ?></span></div>
    </div>
  </div>

  <?php if ($printed < $total_tickets): ?>
    <hr class="cut"><!-- linha de corte manual entre tickets -->
  <?php endif; ?>

<?php endfor; endforeach; ?>
</div>

<!-- ======= LGICA DE IMPRESSO (ESC/POS PRO + Botes) ======= -->
 <script>
(function(){
  /* =====================================================================
   *  CONFIG  layouts independentes
   * ===================================================================== */
  const RAWBT = {
    COLS: 42,                 // largura (CPL) no RawBT
    INDENT: 2,                // recuo do valor nos blocos
    HR_LEN:30,               // comprimento do trao (<= COLS). Use 40 p/ no passar do papel
    // Quais campos AINDA podem tentar uma linha ("Label - Valor"):
    // (removi 'Assento' para evitar confundir com separador)
    INLINE_KEYS: new Set(['Preo unit.','nibus/Barco ID','Tarifa']),
  };
  const QZ = {
    COLS: 48,                 // largura (CPL) no QZ Tray
    LABEL_COLS_MIN: 18,       // coluna de rtulos (esquerda)
    LABEL_COLS_MAX: 24,
  };

  /* =====================================================================
   *  ESC/POS  base e helpers
   * ===================================================================== */
  const ESC='\x1B', GS='\x1D';
  const init=ESC+'@';
  const align=n=>ESC+'a'+String.fromCharCode(n);
  const boldOn=ESC+'E'+'\x01', boldOff=ESC+'E'+'\x00';
  const size1x=GS+'!'+'\x00', size2x=GS+'!'+'\x11';
  const feed=n=>ESC+'d'+String.fromCharCode(n);
  const cut=GS+'V'+'\x00';

  const clean=t=>(t||'').replace(/\s+/g,' ').trim();

  function wrap(str, width){
    str = String(str ?? '');
    if (width <= 1) return [str];
    const words = clean(str).split(/\s+/);
    const out=[]; let line='';
    for (const w of words){
      const tryL = line ? (line+' '+w) : w;
      if (tryL.length > width){
        if (line) out.push(line);
        if (w.length > width){
          for (let i=0; i<w.length; i+=width) out.push(w.slice(i, i+width));
          line='';
        } else {
          line=w;
        }
      } else {
        line=tryL;
      }
    }
    if (line) out.push(line);
    return out;
  }

  function hr(ch, width){ return (ch.repeat(width)) + '\n'; }

  function center(text, width){
    return wrap(text, width).map(ln=>{
      const pad = Math.max(0, Math.floor((width - ln.length)/2));
      return ' '.repeat(pad) + ln + '\n';
    }).join('');
  }

  // ---------- Sanitizao para RAWBT (ASCII seguro) ----------
  const SANITIZE = { RAWBT_MODE: 'ascii' }; // 'ascii' (recomendado) ou 'none'
  function stripDiacritics(s){
    return String(s ?? '')
      .normalize('NFD').replace(/[\u0300-\u036f]/g, '')
      .replace(//g,'c').replace(//g,'C')
      .replace(//g,'n').replace(//g,'N')
      .replace(/[]/g,'"').replace(/[]/g,"'")
      .replace(/|/g,'-')
      .replace(//g,'-')
      .replace(//g,'EUR').replace(//g,'GBP')
      .replace(//g,'o').replace(//g,'a')
      .replace(//g,'(c)').replace(//g,'(R)');
  }
  function S_RAWBT(s){
    return SANITIZE.RAWBT_MODE === 'ascii' ? stripDiacritics(s) : String(s ?? '');
  }

  // 2 colunas (QZ)
  function col2(label, value, width, lw){
    label = clean(label).replace(/:$/,'');
    value = clean(value);
    const rw = Math.max(1, width - lw);
    const left = wrap(label, lw);
    const right = wrap(value, rw);
    const rows = Math.max(left.length, right.length);
    let out='';
    for(let i=0;i<rows;i++){
      const L = (left[i]  || '');
      const R = (right[i] || '');
      const Lpad = L + ' '.repeat(Math.max(0, lw - L.length));
      const Rpad = ' '.repeat(Math.max(0, rw - R.length)) + R;
      out += Lpad + Rpad + '\n';
    }
    return out;
  }

  // RAWBT  layout empilhado
  const INDENT_BLOCK = RAWBT.INDENT;
  function blockField(label, value, width, indent = INDENT_BLOCK){
    const l = clean(S_RAWBT(label)).replace(/:$/,'');
    const rw = Math.max(1, width - indent);
    const lines = wrap(clean(S_RAWBT(value)), rw);
    let out = l + ':\n';
    for (const ln of lines) out += ' '.repeat(indent) + ln + '\n';
    return out;
  }
  function inlinePair(label, value, width, dash = true){
    const l = clean(S_RAWBT(label)).replace(/:$/,'');
    const v = clean(S_RAWBT(value));
    const sep = dash ? ' - ' : ': ';
    const line = `${l}${sep}${v}`;
    if (line.length <= width) return line + '\n';
    return blockField(l, v, width);
  }

  // mede maior rtulo (para QZ)
  function scanLabelWidth(ticketEl, width, MIN, MAX){
    const labels = [];
    ticketEl.querySelectorAll('.t-meta div strong').forEach(s => labels.push(clean(s.textContent)));
    ticketEl.querySelectorAll('.tbl tr').forEach(tr=>{
      const tds = tr.querySelectorAll('td');
      if (tds.length >= 2 && !tds[0].hasAttribute('colspan')) {
        labels.push(clean(tds[0].textContent).replace(/:$/,''));
      }
    });
    const maxLen = labels.reduce((m, s) => Math.max(m, s.length), 0);
    const wanted = Math.min(MAX, Math.max(MIN, maxLen + 2));
    const minRight = 12;
    return Math.min(wanted, Math.max(MIN, width - minRight));
  }

  // QR ESC/POS (model 2)
  function qrEscPos(data,{size=6,ecc='M'}={}){
    const eccMap={L:48,M:49,Q:50,H:51};
    const mModel = GS+'(k'+String.fromCharCode(4,0,49,65,50,0);
    const mSize  = GS+'(k'+String.fromCharCode(3,0,49,67,Math.max(1,Math.min(size,16)));
    const mEcc   = GS+'(k'+String.fromCharCode(3,0,49,69,eccMap[ecc]||49);
    const bytes = new TextEncoder().encode(data);
    const pL=(bytes.length+3)&0xFF, pH=((bytes.length+3)>>8)&0xFF;
    const store  = GS+'(k'+String.fromCharCode(pL,pH,49,80,48)+data;
    const print  = GS+'(k'+String.fromCharCode(3,0,49,81,48);
    return mModel+mSize+mEcc+store+print;
  }

  // Base64 de string
  function toB64(str){
    const bytes=new TextEncoder().encode(str); let bin='';
    for(let i=0;i<bytes.length;i++) bin+=String.fromCharCode(bytes[i]);
    return btoa(bin);
  }

  /* =====================================================================
   *  RAWBT  builder empilhado com trao deduplicado e sanitizao
   * ===================================================================== */
  function escposFromTicket_RAWBT(t, idx, total, brand, orderInfo){
    const W  = RAWBT.COLS;
    const HR_LEN = Math.max(1, Math.min(W, RAWBT.HR_LEN || W)); // trao nunca maior que CPL
    const H = '-'.repeat(HR_LEN) + '\n';

    let out=''; const addHr = () => { if (!out.endsWith(H)) out += H; };

    out+=init;
    out+=align(1)+size2x+boldOn+S_RAWBT(brand||'COMPROVANTE')+'\n'+boldOff+size1x;
    out+=S_RAWBT('BILHETE ') + (idx+1) + '/' + total + '\n' + align(0);
    addHr(); // aps o ttulo

    // metas (empilhado)
    const metas=t.querySelectorAll('.t-meta')[0];
    if(metas){
      metas.querySelectorAll('div').forEach(d=>{
        const k=d.querySelector('strong')?.textContent || '';
        const v=d.querySelector('span')?.textContent   || '';
        if(k||v) out+=blockField(k, v, W);
      });
    }

    // rota (empilhado)
    const route=t.querySelector('.route');
    if(route){
      addHr(); // antes da rota
      const cols=route.querySelectorAll('.col');
      const origem = cols[0] ? clean(cols[0].textContent) : '';
      const destino= cols[1] ? clean(cols[1].textContent) : '';
      if (origem)  out+=blockField('Origem',  origem,  W);
      if (destino) out+=blockField('Destino', destino, W);
    }

    // detalhes (empilhado; tenta inline nos curtos)
    const tbl=t.querySelector('.tbl');
    if(tbl){
      addHr(); // antes dos detalhes
      tbl.querySelectorAll('tr').forEach(tr=>{
        const tds=tr.querySelectorAll('td'); if(!tds.length) return;

        if (tds.length===1 || tds[0].hasAttribute('colspan')){
          const title=clean(S_RAWBT(tds[0].textContent));
          if (title) out+=center(title, W);
          return;
        }

        const k=clean(tds[0].textContent).replace(/:$/,'');
        const v=clean(tds[1].textContent);

        if (/^Assento$/i.test(k) && v && v!=='Sem assento'){
          // Forando bloco pra evitar confundir com separador
          out+=blockField('Assento', v, W);
        } else if (/^Categoria\/Tarifa$/i.test(k) || /^Categoria|Tarifa$/i.test(k)) {
          out+=inlinePair('Tarifa', v, W); // tenta "Tarifa - X"
        } else if (RAWBT.INLINE_KEYS.has(k)) {
          out+=inlinePair(k, v, W);
        } else {
          out+=blockField(k, v, W);
        }
      });
    }

    // totais (empilhado)
    const metaBlocks=t.querySelectorAll('.t-meta');
    const totals=metaBlocks[metaBlocks.length-1];
    if(totals){
      addHr(); // antes dos totais
      totals.querySelectorAll('div').forEach(d=>{
        const k=d.querySelector('strong')?.textContent || '';
        const v=d.querySelector('span')?.textContent   || '';
        if(k||v) out+=blockField(k, v, W);
      });
    }

    // rodap + QR
    addHr(); // antes do rodap
    const qrPayload=`PEDIDO|${orderInfo.number}|${orderInfo.total}|${orderInfo.date}`;
    out+=center(S_RAWBT('Apresente no embarque'), W);
    out+=qrEscPos(qrPayload,{size:6,ecc:'M'});
    out+=feed(2)+cut;
    return out;
  }

  function buildTickets_RAWBT(){
    const wrapEl=document.getElementById('ticketWrap'); if(!wrapEl){ alert('Sem .ticket-wrap'); return []; }
    const brand="<?php echo esc_js($brand); ?>";
    const orderInfo={
      number:"<?php echo esc_js($order->get_order_number()); ?>",
      total:"<?php echo esc_js(wp_strip_all_tags($order->get_formatted_order_total())); ?>",
      date:"<?php echo esc_js(wc_format_datetime($order->get_date_created())); ?>"
    };
    const out=[]; const tickets=wrapEl.querySelectorAll('.ticket');
    tickets.forEach((t,i)=> out.push(escposFromTicket_RAWBT(t,i,tickets.length,brand,orderInfo)));
    return out;
  }

  // UI RAWBT
  const rbDot=document.getElementById('rb-dot'), rbStatus=document.getElementById('rb-status');
  if(/Android/i.test(navigator.userAgent)){ rbDot.classList.add('ok'); rbStatus.textContent='Android detectado  pronto para imprimir.'; }
  else { rbDot.classList.add('warn'); rbStatus.textContent='RawBT  Android  teste no celular.'; }
  function openRaw(href){ const a=document.createElement('a'); a.href=href; a.style.display='none'; document.body.appendChild(a); a.click(); a.remove(); }
  document.getElementById('rb-print-all')?.addEventListener('click', ()=>{
    const parts=buildTickets_RAWBT(); if(!parts.length) return;
    openRaw('rawbt:base64,'+toB64(parts.join('')));
  });
  document.getElementById('rb-print-each')?.addEventListener('click', async ()=>{
    const parts=buildTickets_RAWBT();
    for(const p of parts){ openRaw('rawbt:base64,'+toB64(p)); await new Promise(r=>setTimeout(r,700)); }
  });
  document.getElementById('rb-open')?.addEventListener('click', ()=>openRaw('rawbt:'));

  /* =====================================================================
   *  QZ TRAY  builder 2 colunas (UTF-8 intacto)
   * ===================================================================== */
  function escposFromTicket_QZ(t, idx, total, brand, orderInfo){
    const W  = QZ.COLS;
    const LW = scanLabelWidth(t, W, QZ.LABEL_COLS_MIN, QZ.LABEL_COLS_MAX);
    let out=''; out+=init;
    out+=align(1)+size2x+boldOn+(brand||'COMPROVANTE')+'\n'+boldOff+size1x;
    out+='BILHETE '+(idx+1)+'/'+total+'\n'+align(0);
    out+=hr('-', W);

    const metas=t.querySelectorAll('.t-meta')[0];
    if(metas){
      metas.querySelectorAll('div').forEach(d=>{
        const k=d.querySelector('strong')?.textContent || '';
        const v=d.querySelector('span')?.textContent   || '';
        if(k||v) out+=col2(k, v, W, LW);
      });
    }

    const route=t.querySelector('.route');
    if(route){
      out+=hr('-', W);
      const cols=route.querySelectorAll('.col');
      const origem = cols[0] ? clean(cols[0].textContent) : '';
      const destino= cols[1] ? clean(cols[1].textContent) : '';
      if (origem)  out+=col2('Origem',  origem,  W, LW);
      if (destino) out+=col2('Destino', destino, W, LW);
    }

    const tbl=t.querySelector('.tbl');
    if(tbl){
      out+=hr('-', W);
      tbl.querySelectorAll('tr').forEach(tr=>{
        const tds=tr.querySelectorAll('td'); if(!tds.length) return;
        if (tds.length===1 || tds[0].hasAttribute('colspan')){
          const title=clean(tds[0].textContent);
          if (title) out+=center(title, W);
        } else {
          const k=clean(tds[0].textContent).replace(/:$/,'');
          const v=clean(tds[1].textContent);
          if (/^Assento$/i.test(k) && v && v!=='Sem assento'){
            out+=boldOn + col2('Assento', v, W, LW) + boldOff;
          } else if (/^Categoria\/Tarifa$/i.test(k) || /^Categoria|Tarifa$/i.test(k)) {
            out+=boldOn + col2('Tarifa', v, W, LW) + boldOff;
          } else {
            out+=col2(k, v, W, LW);
          }
        }
      });
    }

    const metaBlocks=t.querySelectorAll('.t-meta');
    const totals=metaBlocks[metaBlocks.length-1];
    if(totals){
      out+=hr('-', W);
      totals.querySelectorAll('div').forEach(d=>{
        const k=d.querySelector('strong')?.textContent || '';
        const v=d.querySelector('span')?.textContent   || '';
        if(k||v) out+=col2(k, v, W, LW);
      });
    }

    const qrPayload=`PEDIDO|${orderInfo.number}|${orderInfo.total}|${orderInfo.date}`;
    out+=hr('-', W);
    out+=center('Apresente no embarque', W);
    out+=qrEscPos(qrPayload,{size:6,ecc:'M'});
    out+=feed(2)+cut;
    return out;
  }

  function buildTickets_QZ(){
    const wrapEl=document.getElementById('ticketWrap'); if(!wrapEl){ alert('Sem .ticket-wrap'); return []; }
    const brand="<?php echo esc_js($brand); ?>";
    const orderInfo={
      number:"<?php echo esc_js($order->get_order_number()); ?>",
      total:"<?php echo esc_js(wp_strip_all_tags($order->get_formatted_order_total())); ?>",
      date:"<?php echo esc_js(wc_format_datetime($order->get_date_created())); ?>"
    };
    const out=[]; const tickets=wrapEl.querySelectorAll('.ticket');
    tickets.forEach((t,i)=> out.push(escposFromTicket_QZ(t,i,tickets.length,brand,orderInfo)));
    return out;
  }

  // UI QZ Tray
  const qzDot=document.getElementById('qz-dot'), qzStatus=document.getElementById('qz-status');
  const CERT_URL = "<?php echo esc_js( get_template_directory_uri() . '/qz/digital-certificate.txt' ); ?>";
  const SIGN_URL = "<?php echo esc_js( get_template_directory_uri() . '/qz/sign-message.php?request=' ); ?>";
  function setQZ(msg, cls){ qzStatus.textContent=msg; qzDot.className='dot '+(cls||''); }

  async function ensureQZ(){
    if (typeof qz==='undefined' || !qz.websocket) throw new Error('qz-tray.js no carregado.');
    if (qz.websocket.isActive()) return;
    qz.security.setCertificatePromise((resolve,reject)=>{
      fetch(CERT_URL,{cache:'no-store'}).then(r=>r.ok?r.text():Promise.reject('Certificado no encontrado')).then(resolve).catch(reject);
    });
    qz.security.setSignatureAlgorithm("SHA512");
    qz.security.setSignaturePromise(toSign=>(resolve,reject)=>{
      fetch(SIGN_URL+encodeURIComponent(toSign),{cache:'no-store'}).then(r=>r.ok?r.text():Promise.reject('Assinatura falhou')).then(resolve).catch(reject);
    });
    setQZ('Conectando',''); await qz.websocket.connect().then(()=>setQZ('Conectado!','ok'));
  }

  async function listPrinters(){
    await ensureQZ(); setQZ('Listando impressoras','');
    let names=[]; if(qz.printers?.find) names=await qz.printers.find();
    else if(qz.printers?.details){ const det=await qz.printers.details(); names=Array.isArray(det)?det.map(p=>p?.name||p):[]; }
    const sel=document.getElementById('qz-select'); sel.innerHTML='';
    if(!names.length){
      sel.appendChild(new Option('Nenhuma encontrada',''));
      sel.disabled=true;
      document.getElementById('qz-print-all').disabled=true;
      document.getElementById('qz-print-each').disabled=true;
      setQZ('Nenhuma impressora encontrada.','warn'); return;
    }
    names.forEach(n=> sel.appendChild(new Option(n,n)));
    sel.disabled=false;
    document.getElementById('qz-print-all').disabled=false;
    document.getElementById('qz-print-each').disabled=false;
    try{ const def=await qz.printers.getDefault(); if(def && [...sel.options].some(o=>o.value===def)) sel.value=def; }catch{}
    setQZ('Selecione e imprima.','ok');
  }

  async function qzPrint(mode){
    const sel=document.getElementById('qz-select'); const chosen=sel.value;
    if(!chosen){ alert('Escolha uma impressora.'); return; }
    await ensureQZ();
    const parts=buildTickets_QZ();
    const cfg=qz.configs.create(chosen,{encoding:'UTF-8'}); // mude para 'CP860' se for necessrio
    if(mode==='all'){ await qz.print(cfg, [{type:'raw', format:'base64', data: toB64(parts.join(''))}]); }
    else{ for(const p of parts) await qz.print(cfg, [{type:'raw', format:'base64', data: toB64(p)}]); }
  }

  document.getElementById('qz-connect')?.addEventListener('click', async ()=>{ try{ await ensureQZ(); await listPrinters(); }catch(e){ setQZ('Erro: '+(e?.message||e),'err'); }});
  document.getElementById('qz-refresh')?.addEventListener('click', async ()=>{ try{ await listPrinters(); }catch(e){ setQZ('Erro: '+(e?.message||e),'err'); }});
  document.getElementById('qz-disconnect')?.addEventListener('click', async ()=>{ try{ if(qz?.websocket?.isActive()) await qz.websocket.disconnect(); setQZ('Desconectado.',''); }catch(e){ setQZ('Erro: '+(e?.message||e),'err'); }});
  document.getElementById('qz-print-all')?.addEventListener('click', ()=>qzPrint('all'));
  document.getElementById('qz-print-each')?.addEventListener('click', ()=>qzPrint('each'));
})();
</script>


<!-- QZ Tray -->
<script src="<?php echo get_template_directory_uri(); ?>/qz/js/qz-tray.js"></script>
</body>
</html>
